<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';
require_once __DIR__ . '/api/esim-api.php';

requireLogin();

$pageTitle = 'eSIM های من';

// Get user's paid orders
$conn = getDBConnection();
$stmt = $conn->prepare("SELECT * FROM orders WHERE user_id = ? AND status = 'paid' ORDER BY created_at DESC");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$result = $stmt->get_result();
$esims = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
$conn->close();

$api = new eSIMAPI();

include __DIR__ . '/includes/header.php';
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700;800&display=swap');

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Vazirmatn', sans-serif;
    background: linear-gradient(135deg, #7c8ff8 0%, #9ba5f9 100%);
    min-height: 100vh;
    padding: 30px 20px;
    direction: rtl;
}

.container {
    max-width: 1400px;
    margin: 0 auto;
}

/* Header */
.page-header {
    background: white;
    border-radius: 20px;
    padding: 25px 30px;
    margin-bottom: 30px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.page-header h1 {
    font-size: 1.8rem;
    font-weight: 800;
    color: #1e293b;
}

.btn-refresh {
    background: linear-gradient(135deg, #7c8ff8 0%, #9ba5f9 100%);
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 10px;
    font-weight: 700;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 8px;
}

/* eSIM Grid */
.esims-grid {
    display: flex;
    flex-direction: column;
    gap: 20px;
    max-width: 1200px;
    margin: 0 auto;
}

@media (max-width: 768px) {
    .esims-grid {
        gap: 15px;
    }
}

/* eSIM Card Simple */
.esim-card-simple {
    background: white;
    border-radius: 15px;
    padding: 30px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    display: grid;
    grid-template-columns: 120px 1fr auto;
    align-items: center;
    gap: 30px;
    transition: all 0.3s ease;
}

.esim-card-simple:hover {
    box-shadow: 0 8px 25px rgba(0,0,0,0.15);
    transform: translateY(-2px);
}

/* Flag */
.simple-flag {
    width: 120px;
    height: 85px;
    border-radius: 12px;
    overflow: hidden;
    flex-shrink: 0;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.simple-flag img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* Info */
.simple-info {
    display: flex;
    flex-direction: column;
    gap: 8px;
    min-width: 0;
}

.simple-country {
    font-size: 1.5rem;
    font-weight: 800;
    color: #1e293b;
    line-height: 1.2;
}

.simple-package {
    font-size: 1.1rem;
    color: #64748b;
    font-weight: 600;
    line-height: 1.4;
}

/* Button Details */
.btn-details {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    background: linear-gradient(135deg, #6b7ff5 0%, #8a96f7 100%);
    color: white;
    padding: 15px 30px;
    border-radius: 12px;
    text-decoration: none;
    font-weight: 700;
    font-size: 1rem;
    transition: all 0.3s ease;
    flex-shrink: 0;
    white-space: nowrap;
    min-width: 180px;
}

.btn-details:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(107, 127, 245, 0.4);
    background: linear-gradient(135deg, #5a6de8 0%, #7b87f0 100%);
}

.btn-details i {
    font-size: 1.2rem;
}

/* Button Topup */
.btn-topup {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
    padding: 15px 30px;
    border-radius: 12px;
    text-decoration: none;
    font-weight: 700;
    font-size: 1rem;
    transition: all 0.3s ease;
    flex-shrink: 0;
    white-space: nowrap;
    min-width: 180px;
}

.btn-topup:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(16, 185, 129, 0.4);
    background: linear-gradient(135deg, #059669 0%, #047857 100%);
}

.btn-topup i {
    font-size: 1.2rem;
}

/* eSIM Card - قدیمی */
.esim-card {
    background: white;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 8px 25px rgba(0,0,0,0.12);
    display: flex;
    flex-direction: column;
    height: 100%;
}

/* Card Header */
.card-header {
    background: linear-gradient(135deg, #6b7ff5 0%, #8a96f7 100%);
    padding: 30px;
    position: relative;
    min-height: 320px;
}

.card-header.expired {
    background: linear-gradient(135deg, #94a3b8 0%, #64748b 100%);
}

/* Status Badge - بالا سمت راست */
.status-badge {
    position: absolute;
    top: 20px;
    right: 20px;
    padding: 6px 16px;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 5px;
    background: rgba(34, 197, 94, 0.95);
    color: white;
    box-shadow: 0 3px 10px rgba(34, 197, 94, 0.3);
}

.status-badge.expired {
    background: rgba(239, 68, 68, 0.95);
}

/* Package Info - وسط */
.package-info {
    text-align: center;
    padding-top: 40px;
}

.package-name {
    font-size: 1.8rem;
    font-weight: 800;
    color: white;
    margin-bottom: 8px;
}

.package-details {
    font-size: 1.4rem;
    font-weight: 700;
    color: white;
    margin-bottom: 12px;
}

.country-name {
    font-size: 1rem;
    font-weight: 600;
    color: rgba(255,255,255,0.95);
}

/* Country with Flag - کنار هم */
.country-with-flag {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-top: 8px;
}

.country-flag-inline {
    width: 32px;
    height: 24px;
    border-radius: 4px;
    object-fit: cover;
    box-shadow: 0 2px 6px rgba(0,0,0,0.2);
    border: 1.5px solid rgba(255,255,255,0.4);
}

/* Country Flag - قدیمی (پایین سمت چپ) */
.country-flag {
    position: absolute;
    bottom: 20px;
    left: 20px;
    width: 55px;
    height: 42px;
    border-radius: 8px;
    object-fit: cover;
    box-shadow: 0 3px 10px rgba(0,0,0,0.2);
    border: 2.5px solid rgba(255,255,255,0.35);
}

/* Detail Boxes - پایین سمت راست */
.detail-boxes {
    position: absolute;
    bottom: 20px;
    right: 20px;
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 8px;
    width: 280px;
}

.detail-box {
    background: rgba(255,255,255,0.2);
    backdrop-filter: blur(12px);
    -webkit-backdrop-filter: blur(12px);
    border: 1px solid rgba(255,255,255,0.3);
    border-radius: 12px;
    padding: 10px 8px;
    text-align: center;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    min-height: 80px;
    height: 100%;
}

.detail-icon {
    color: rgba(255,255,255,0.95);
    font-size: 1.2rem;
    margin-bottom: 6px;
    display: block;
    line-height: 1;
}

.detail-value {
    color: white;
    font-size: 0.9rem;
    font-weight: 700;
    white-space: nowrap;
    display: block;
    line-height: 1.2;
    margin-bottom: 2px;
}

.detail-label {
    color: rgba(255,255,255,0.85);
    font-size: 0.7rem;
    font-weight: 600;
    display: block;
    line-height: 1;
}

/* Card Body */
.card-body {
    padding: 25px;
    flex: 1;
    display: flex;
    flex-direction: column;
}

/* Flag Center - پرچم بزرگ وسط */
.flag-center {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    padding: 30px 20px;
}

.country-flag-large {
    width: 120px;
    height: 85px;
    border-radius: 12px;
    object-fit: cover;
    box-shadow: 0 8px 20px rgba(0,0,0,0.25);
    border: 3px solid rgba(255,255,255,0.5);
    margin-bottom: 15px;
}

.country-name-large {
    font-size: 1.4rem;
    font-weight: 800;
    color: white;
    text-align: center;
}

/* Circular Progress Box - نمودار دایره‌ای */
.circular-progress-box {
    background: white;
    border: 2px solid #e2e8f0;
    border-radius: 15px;
    padding: 20px;
    margin-bottom: 15px;
}

.circular-progress-title {
    display: flex;
    align-items: center;
    gap: 8px;
    color: #475569;
    font-weight: 700;
    font-size: 1rem;
    margin-bottom: 20px;
}

.circular-progress-title i {
    color: #6b7ff5;
    font-size: 1.1rem;
}

.circular-progress-wrapper {
    display: flex;
    align-items: center;
    justify-content: space-around;
    gap: 30px;
}

.circular-progress {
    position: relative;
    width: 180px;
    height: 180px;
    flex-shrink: 0;
}

.progress-circle {
    transition: stroke-dasharray 0.5s ease;
}

.circular-progress-text {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    text-align: center;
}

.circular-percentage {
    font-size: 2.5rem;
    font-weight: 800;
    color: #6b7ff5;
    line-height: 1;
    margin-bottom: 5px;
}

.circular-label {
    font-size: 0.8rem;
    color: #64748b;
    font-weight: 600;
}

.circular-stats {
    display: flex;
    flex-direction: column;
    gap: 15px;
    flex: 1;
}

.circular-stat-item {
    display: flex;
    align-items: center;
    gap: 12px;
    background: #f8fafc;
    padding: 12px;
    border-radius: 12px;
}

.circular-stat-icon {
    width: 45px;
    height: 45px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
    flex-shrink: 0;
}

.circular-stat-content {
    flex: 1;
}

.circular-stat-label {
    font-size: 0.75rem;
    color: #64748b;
    font-weight: 600;
    margin-bottom: 3px;
}

.circular-stat-value {
    font-size: 1rem;
    color: #1e293b;
    font-weight: 700;
}

/* Not Activated Message - پیام اکتیو نشده */
.not-activated-message {
    display: flex;
    align-items: center;
    gap: 15px;
    background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
    padding: 20px;
    border-radius: 12px;
    color: white;
}

.not-activated-icon {
    width: 50px;
    height: 50px;
    background: rgba(255,255,255,0.25);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    flex-shrink: 0;
}

.not-activated-text {
    flex: 1;
}

.not-activated-title {
    font-size: 1rem;
    font-weight: 700;
    margin-bottom: 5px;
}

.not-activated-desc {
    font-size: 0.85rem;
    opacity: 0.95;
    line-height: 1.4;
}

/* Time Remaining Box - باکس مدت زمان باقیمانده */
.time-remaining-box {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    border-radius: 15px;
    padding: 20px;
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 15px;
    box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3);
}

.time-icon {
    width: 55px;
    height: 55px;
    background: rgba(255,255,255,0.25);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.8rem;
    color: white;
    flex-shrink: 0;
}

.time-content {
    flex: 1;
}

.time-label {
    color: rgba(255,255,255,0.9);
    font-size: 0.85rem;
    font-weight: 600;
    margin-bottom: 5px;
}

.time-value {
    color: white;
    font-size: 2rem;
    font-weight: 800;
    line-height: 1;
}

.time-value span {
    font-size: 1.2rem;
    font-weight: 600;
}

/* Operator Box - باکس اطلاعات اپراتور */
.operator-box {
    background: white;
    border: 2px solid #e2e8f0;
    border-radius: 15px;
    overflow: hidden;
    margin-bottom: 15px;
}

.operator-header {
    background: linear-gradient(135deg, #6b7ff5 0%, #8a96f7 100%);
    color: white;
    padding: 12px 18px;
    display: flex;
    align-items: center;
    gap: 10px;
    font-weight: 700;
    font-size: 0.95rem;
}

.operator-header i {
    font-size: 1.1rem;
}

.operator-content {
    padding: 15px;
}

.operator-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 10px 0;
    border-bottom: 1px solid #e2e8f0;
}

.operator-item:last-child {
    border-bottom: none;
}

.operator-label {
    color: #64748b;
    font-size: 0.85rem;
    font-weight: 600;
}

.operator-value {
    color: #1e293b;
    font-size: 0.9rem;
    font-weight: 700;
    text-align: left;
}

.status-active-text {
    color: #10b981;
}

.status-inactive-text {
    color: #ef4444;
}

/* Info Box - باکس اصلی اطلاعات */
.info-box {
    background: #f8fafc;
    border: 2px solid #e2e8f0;
    border-radius: 15px;
    overflow: hidden;
    margin-bottom: 18px;
}

.info-box-header {
    background: linear-gradient(135deg, #6b7ff5 0%, #8a96f7 100%);
    color: white;
    padding: 12px 18px;
    display: flex;
    align-items: center;
    gap: 10px;
    font-weight: 700;
    font-size: 0.95rem;
}

.info-box-header i {
    font-size: 1.1rem;
}

.info-box-content {
    padding: 18px;
}

.info-section {
    margin-bottom: 15px;
}

.info-section:last-child {
    margin-bottom: 0;
}

.info-section-title {
    display: flex;
    align-items: center;
    gap: 8px;
    color: #475569;
    font-weight: 700;
    font-size: 0.9rem;
    margin-bottom: 12px;
}

.info-section-title i {
    color: #6b7ff5;
}

.info-divider {
    height: 1px;
    background: #e2e8f0;
    margin: 15px 0;
}

/* Data Usage */
.data-usage {
    background: #f8fafc;
    border-radius: 12px;
    padding: 18px;
    margin-bottom: 18px;
}

.usage-title {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 12px;
    color: #1e293b;
    font-weight: 700;
    font-size: 0.95rem;
}

.progress-bar-bg {
    width: 100%;
    height: 8px;
    background: #e2e8f0;
    border-radius: 10px;
    overflow: hidden;
    margin-bottom: 10px;
}

.progress-bar-fill {
    height: 100%;
    background: linear-gradient(90deg, #6b7ff5 0%, #8a96f7 100%);
    border-radius: 10px;
    transition: width 1s ease;
}

.usage-stats {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 8px;
}

.usage-stat {
    text-align: center;
    padding: 8px;
}

.usage-stat-value {
    font-size: 1.1rem;
    font-weight: 800;
    color: #1e293b;
    display: block;
}

.usage-stat-label {
    font-size: 0.7rem;
    color: #64748b;
    font-weight: 600;
}

/* Info Box - باکس اطلاعات */
.info-box {
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    border: 1px solid #e2e8f0;
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 18px;
}

.info-box-title {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 15px;
    color: #1e293b;
    font-weight: 700;
    font-size: 0.95rem;
}

.info-box-title i {
    color: #6b7ff5;
}

.info-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 12px;
}

.info-item {
    background: white;
    padding: 12px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    gap: 10px;
    border: 1px solid #e2e8f0;
}

.info-icon {
    width: 34px;
    height: 34px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.95rem;
    color: white;
    flex-shrink: 0;
}

.info-icon.status-active { background: linear-gradient(135deg, #10b981 0%, #059669 100%); }
.info-icon.status-inactive { background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); }
.info-icon.default { background: linear-gradient(135deg, #6b7ff5 0%, #8a96f7 100%); }

.info-content {
    flex: 1;
}

.info-label {
    font-size: 0.7rem;
    color: #64748b;
    font-weight: 600;
}

.info-value {
    font-size: 0.85rem;
    color: #1e293b;
    font-weight: 700;
}

/* Info Items داخل باکس */
.info-items {
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.info-item-row {
    background: white;
    padding: 12px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    gap: 12px;
    border: 1px solid #e2e8f0;
}

.info-item-icon {
    width: 36px;
    height: 36px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.95rem;
    color: white;
    flex-shrink: 0;
}

.info-item-icon.status-active { background: linear-gradient(135deg, #10b981 0%, #059669 100%); }
.info-item-icon.status-inactive { background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); }
.info-item-icon.default { background: linear-gradient(135deg, #6b7ff5 0%, #8a96f7 100%); }

.info-item-content {
    flex: 1;
}

.info-item-label {
    font-size: 0.75rem;
    color: #64748b;
    font-weight: 600;
    margin-bottom: 2px;
}

.info-item-value {
    font-size: 0.9rem;
    color: #1e293b;
    font-weight: 700;
}

/* QR Section */
.qr-section {
    background: #f8fafc;
    border-radius: 12px;
    padding: 18px;
    text-align: center;
    margin-bottom: 18px;
}

.qr-wrapper {
    display: inline-block;
    padding: 10px;
    background: white;
    border-radius: 10px;
    box-shadow: 0 3px 10px rgba(0,0,0,0.1);
    margin-bottom: 10px;
}

.qr-wrapper img {
    display: block;
    max-width: 160px;
    height: auto;
}

.btn-auto-add {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 10px 20px;
    background: linear-gradient(135deg, #6b7ff5 0%, #8a96f7 100%);
    color: white;
    border: none;
    border-radius: 10px;
    font-weight: 700;
    font-size: 0.85rem;
    cursor: pointer;
    text-decoration: none;
    width: 100%;
    margin-top: 8px;
}

/* Activation Code */
.activation-section {
    margin-bottom: 18px;
}

.activation-label {
    font-size: 0.8rem;
    color: #475569;
    font-weight: 700;
    margin-bottom: 8px;
    display: block;
}

.activation-box {
    display: flex;
    gap: 8px;
}

.activation-code {
    flex: 1;
    background: #f1f5f9;
    border: 2px solid #cbd5e1;
    border-radius: 8px;
    padding: 10px;
    font-family: 'Courier New', monospace;
    font-size: 0.75rem;
    color: #1e293b;
    word-break: break-all;
    direction: ltr;
    text-align: left;
}

.btn-copy {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
    border: none;
    padding: 10px 16px;
    border-radius: 8px;
    cursor: pointer;
    font-weight: 700;
    font-size: 0.8rem;
    white-space: nowrap;
}

/* ICCID */
.iccid-box {
    background: #f8fafc;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    padding: 10px;
    margin-bottom: 18px;
    font-size: 0.75rem;
}

.iccid-label {
    color: #64748b;
    font-weight: 700;
    margin-bottom: 3px;
}

.iccid-value {
    font-family: 'Courier New', monospace;
    color: #1e293b;
    font-weight: 600;
    direction: ltr;
    word-break: break-all;
    font-size: 0.8rem;
    background: white;
    padding: 10px;
    border-radius: 8px;
    border: 1px solid #e2e8f0;
}

/* Actions */
.action-buttons {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 8px;
}

.btn-action {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 6px;
    padding: 10px 14px;
    border-radius: 8px;
    font-weight: 600;
    font-size: 0.8rem;
    cursor: pointer;
    text-decoration: none;
}

.btn-outline {
    background: white;
    color: #6b7ff5;
    border: 2px solid #6b7ff5;
}

.btn-primary {
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: white;
    border: none;
}

/* Instructions */
.instructions {
    background: #f8fafc;
    border: 1px solid #e2e8f0;
    border-radius: 10px;
    padding: 15px;
    margin-top: 12px;
    display: none;
    font-size: 0.8rem;
}

.instructions.show {
    display: block;
}

.instructions h4 {
    color: #1e293b;
    font-weight: 700;
    font-size: 0.9rem;
    margin-bottom: 12px;
}

.instruction-block {
    margin-bottom: 12px;
}

.instruction-block h5 {
    color: #475569;
    font-weight: 700;
    font-size: 0.85rem;
    margin-bottom: 8px;
}

.instruction-block ol {
    padding-right: 18px;
}

.instruction-block li {
    color: #64748b;
    margin-bottom: 5px;
    font-size: 0.8rem;
}

/* Empty State */
.empty-state {
    background: white;
    border-radius: 20px;
    padding: 50px 30px;
    text-align: center;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
}

.empty-icon {
    width: 90px;
    height: 90px;
    margin: 0 auto 20px;
    background: linear-gradient(135deg, #e2e8f0 0%, #cbd5e1 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 3rem;
    color: #94a3b8;
}

.empty-state h2 {
    color: #1e293b;
    font-size: 1.6rem;
    font-weight: 800;
    margin-bottom: 10px;
}

.empty-state p {
    color: #64748b;
    margin-bottom: 20px;
}

.btn-large {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 12px 30px;
    background: linear-gradient(135deg, #6b7ff5 0%, #8a96f7 100%);
    color: white;
    border: none;
    border-radius: 12px;
    font-weight: 700;
    cursor: pointer;
    text-decoration: none;
}

/* Responsive */
@media (max-width: 768px) {
    body { padding: 15px; }
    
    .page-header {
        flex-direction: column;
        gap: 15px;
    }
    
    .btn-refresh {
        width: 100%;
        justify-content: center;
    }
    
    .esims-grid {
        grid-template-columns: 1fr;
    }
    
    .esim-card-simple {
        grid-template-columns: 1fr;
        text-align: center;
        padding: 20px;
        gap: 15px;
    }
    
    .simple-flag {
        width: 100px;
        height: 70px;
        margin: 0 auto;
    }
    
    .simple-info {
        text-align: center;
    }
    
    .simple-country {
        font-size: 1.2rem;
    }
    
    .simple-package {
        font-size: 0.95rem;
    }
    
    .btn-details, .btn-topup {
        width: 100%;
        justify-content: center;
        min-width: auto;
    }
    
    .circular-progress-wrapper {
        flex-direction: column;
        gap: 20px;
    }
    
    .circular-progress {
        margin: 0 auto;
    }
    
    .circular-stats {
        width: 100%;
    }
    
    .compact-card {
        flex-wrap: wrap;
        gap: 10px;
    }
    
    .compact-flag {
        width: 60px;
        height: 45px;
    }
    
    .compact-info {
        flex: 1 1 100%;
        order: 3;
    }
    
    .compact-stats {
        flex-direction: column;
        gap: 8px;
    }
    
    .compact-stat {
        font-size: 0.8rem;
        padding: 6px 10px;
    }
    
    .detail-boxes {
        flex-direction: column;
        right: 20px;
        left: auto;
        gap: 8px;
    }
    
    .detail-box {
        min-width: 120px;
    }
    
    .country-flag {
        bottom: auto;
        top: 20px;
        left: 20px;
    }
    
    .info-grid {
        grid-template-columns: 1fr;
    }
    
    .activation-box {
        flex-direction: column;
    }
    
    .btn-copy {
        width: 100%;
    }
    
    .action-buttons {
        grid-template-columns: 1fr;
    }
}
</style>

<div class="container">
    <!-- Header -->
    <div class="page-header">
        <h1>eSIM های من</h1>
        <button onclick="location.reload()" class="btn-refresh">
            <i class="fas fa-sync-alt"></i>
            <span>بروزرسانی</span>
        </button>
    </div>

    <?php if (!empty($esims)): ?>
        <!-- eSIMs Grid -->
        <div class="esims-grid">
            <?php foreach ($esims as $esim): 
                // Initialize variables
                $apiData = null;
                $isExpired = false;
                $isActive = false;
                $totalData = null;
                $usedData = null;
                $remainingData = null;
                $expiryDate = null;
                $activationTime = null;
                $network = null;
                
                // Try to get API data
                if (!empty($esim['iccid'])) {
                    try {
                        $apiResponse = $api->queryProfile($esim['iccid']);
                        
                        $isSuccess = false;
                        if (isset($apiResponse['code']) && $apiResponse['code'] == 0) {
                            $isSuccess = true;
                        } elseif (isset($apiResponse['success']) && $apiResponse['success'] === true) {
                            $isSuccess = true;
                        } elseif (isset($apiResponse['errorCode']) && $apiResponse['errorCode'] === '000000') {
                            $isSuccess = true;
                        }
                        
                        if ($apiResponse && $isSuccess) {
                            $esimList = $apiResponse['obj']['esimList'] ?? ($apiResponse['obj'] ?? null);
                            
                            if (is_array($esimList) && !empty($esimList)) {
                                $apiData = is_array($esimList[0]) ? $esimList[0] : $esimList;
                                
                                // وضعیت: esimStatus (ACTIVE, CANCEL, etc.)
                                $isActive = isset($apiData['esimStatus']) && $apiData['esimStatus'] == 'ACTIVE';
                                
                                // تاریخ انقضا: expiredTime
                                if (isset($apiData['expiredTime'])) {
                                    $expiryDate = $apiData['expiredTime'];
                                    $expiryTimestamp = strtotime($expiryDate);
                                    $isExpired = $expiryTimestamp < time();
                                }
                                
                                // زمان فعال‌سازی: activateTime
                                if (isset($apiData['activateTime']) && $apiData['activateTime']) {
                                    $activationTime = $apiData['activateTime'];
                                }
                                
                                // APN (به عنوان اپراتور/شبکه): apn
                                if (isset($apiData['apn']) && $apiData['apn']) {
                                    $network = $apiData['apn'];
                                }
                                
                                // حجم داده: totalVolume و orderUsage
                                if (isset($apiData['totalVolume'])) {
                                    $totalData = $apiData['totalVolume']; // به بایت
                                    $usedData = $apiData['orderUsage'] ?? 0; // به بایت
                                    $remainingData = $totalData - $usedData;
                                }
                            }
                        }
                    } catch (Exception $e) {
                        // Silently fail
                    }
                }
                
                // Fallback to local data
                if (!$apiData && isset($esim['validity_days']) && isset($esim['created_at'])) {
                    $createdTime = strtotime($esim['created_at']);
                    $expiryTime = $createdTime + ($esim['validity_days'] * 24 * 60 * 60);
                    $isExpired = $expiryTime < time();
                    $expiryDate = date('Y-m-d H:i:s', $expiryTime);
                }
                
                $usagePercentage = 0;
                if ($totalData > 0 && $usedData !== null) {
                    $usagePercentage = round(($usedData / $totalData) * 100, 1);
                }
                
                $cardHeaderClass = $isExpired ? 'card-header expired' : 'card-header';
                $statusBadgeClass = $isExpired ? 'status-badge expired' : 'status-badge';
                $statusText = $isExpired ? 'منقضی' : 'فعال';
                $statusIcon = $isExpired ? 'fa-times-circle' : 'fa-check-circle';
            ?>
            <div class="esim-card-simple">
                <!-- پرچم -->
                <div class="simple-flag">
                    <?php if (!empty($esim['country_code'])): ?>
                    <img src="https://flagcdn.com/w160/<?php echo strtolower($esim['country_code']); ?>.png" 
                         alt="<?php echo htmlspecialchars($esim['country_name'] ?? ''); ?>"
                         onerror="this.style.display='none'">
                    <?php endif; ?>
                </div>
                
                <!-- اطلاعات -->
                <div class="simple-info">
                    <div class="simple-country"><?php echo htmlspecialchars($esim['country_name'] ?? ''); ?></div>
                    <div class="simple-package"><?php echo htmlspecialchars($esim['package_name'] ?? 'eSIM'); ?></div>
                </div>
                
                <!-- دکمه جزئیات -->
                <a href="/esim-details.php?id=<?php echo $esim['id']; ?>" class="btn-details">
                    <i class="fas fa-info-circle"></i>
                    <span>جزئیات eSIM</span>
                </a>
            </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <!-- Empty State -->
        <div class="empty-state">
            <div class="empty-icon">
                <i class="fas fa-sim-card"></i>
            </div>
            <h2>هنوز eSIM ای خریداری نکرده‌اید</h2>
            <p>برای خرید eSIM، کشور مورد نظر خود را انتخاب کنید.</p>
            <a href="/" class="btn-large">
                <i class="fas fa-shopping-cart"></i>
                <span>خرید eSIM</span>
            </a>
        </div>
    <?php endif; ?>
</div>

<script>
function copyCode(id, code) {
    navigator.clipboard.writeText(code).then(function() {
        const button = event.target.closest('button');
        if (button) {
            const originalText = button.innerHTML;
            button.innerHTML = '<i class="fas fa-check"></i> کپی شد!';
            button.style.background = '#10b981';
            
            setTimeout(function() {
                button.innerHTML = originalText;
                button.style.background = '';
            }, 2000);
        }
    }, function() {
        alert('خطا در کپی کردن');
    });
}

function toggleInstructions(id) {
    const panel = document.getElementById('instructions-' + id);
    if (panel) {
        panel.classList.toggle('show');
    }
}
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
